
EXECUTE DBMS_ADVISOR.QUICK_TUNE(DBMS_ADVISOR.SQLACCESS_ADVISOR,'TAREFA_SQL_01_B','SELECT TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,''YYYY-MM'') AS MES_ANO, SUM(ITENS_NOTAS_FISCAIS.QUANTIDADE * ITENS_NOTAS_FISCAIS.PRECO) AS TOTAL_VENDA FROM NOTAS_FISCAIS INNER JOIN ITENS_NOTAS_FISCAIS ON NOTAS_FISCAIS.NUMERO = ITENS_NOTAS_FISCAIS.NUMERO GROUP BY TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,''YYYY-MM'') ORDER BY TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,''YYYY-MM'')');

EXECUTE DBMS_ADVISOR.CREATE_FILE(DBMS_ADVISOR.GET_TASK_SCRIPT('TAREFA_SQL_01_B'),'TUNE_SCRIPTS','TAREFA_SQL_01_B.SQL');

CREATE MATERIALIZED VIEW "USER13"."TAREFA_SQL_01_B"
    REFRESH FORCE WITH ROWID
    ENABLE QUERY REWRITE
    AS SELECT TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,'YYYY-MM') AS MES_ANO, SUM(ITENS_NOTAS_FISCAIS.QUANTIDADE
       * ITENS_NOTAS_FISCAIS.PRECO) AS TOTAL_VENDA FROM NOTAS_FISCAIS INNER JOIN
       ITENS_NOTAS_FISCAIS ON NOTAS_FISCAIS.NUMERO = ITENS_NOTAS_FISCAIS.NUMERO
       GROUP BY TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,'YYYY-MM');

begin
  dbms_stats.gather_table_stats('"USER13"','"TAREFA_SQL_01_B"',NULL,dbms_stats.auto_sample_size);
end;

SELECT TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,'YYYY-MM') AS MES_ANO, SUM(ITENS_NOTAS_FISCAIS.QUANTIDADE * ITENS_NOTAS_FISCAIS.PRECO) AS TOTAL_VENDA
FROM NOTAS_FISCAIS INNER JOIN ITENS_NOTAS_FISCAIS
ON NOTAS_FISCAIS.NUMERO = ITENS_NOTAS_FISCAIS.NUMERO
GROUP BY TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,'YYYY-MM')
ORDER BY TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,'YYYY-MM');

EXECUTE DBMS_ADVISOR.QUICK_TUNE(DBMS_ADVISOR.SQLACCESS_ADVISOR,'TAREFA_SQL_02_B','SELECT TABELA_DE_CLIENTES.ESTADO, NOTAS_FISCAIS.TIPO_VENDA, TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,''YYYY-MM'') AS MES_ANO, COUNT(NOTAS_FISCAIS.NUMERO) AS NUMERO_VENDAS  FROM NOTAS_FISCAIS INNER JOIN TABELA_DE_CLIENTES ON NOTAS_FISCAIS.CPF = TABELA_DE_CLIENTES.CPF GROUP BY TABELA_DE_CLIENTES.ESTADO, NOTAS_FISCAIS.TIPO_VENDA, TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,''YYYY-MM'') ORDER BY TABELA_DE_CLIENTES.ESTADO, NOTAS_FISCAIS.TIPO_VENDA, TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,''YYYY-MM'')');

EXECUTE DBMS_ADVISOR.CREATE_FILE(DBMS_ADVISOR.GET_TASK_SCRIPT('TAREFA_SQL_02_B'),'TUNE_SCRIPTS','TAREFA_SQL_02_B.SQL');

CREATE MATERIALIZED VIEW "USER13"."TAREFA_SQL_02_B"
    REFRESH FORCE WITH ROWID
    ENABLE QUERY REWRITE
    AS SELECT TABELA_DE_CLIENTES.ESTADO, NOTAS_FISCAIS.TIPO_VENDA, TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,
       'YYYY-MM') AS MES_ANO, COUNT(NOTAS_FISCAIS.NUMERO) AS NUMERO_VENDAS FROM
       NOTAS_FISCAIS INNER JOIN TABELA_DE_CLIENTES ON NOTAS_FISCAIS.CPF = TABELA_DE_CLIENTES.CPF
       GROUP BY TABELA_DE_CLIENTES.ESTADO, NOTAS_FISCAIS.TIPO_VENDA, TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,
       'YYYY-MM');

begin
  dbms_stats.gather_table_stats('"USER13"','"TAREFA_SQL_02_B"',NULL,dbms_stats.auto_sample_size);
end;

SELECT TABELA_DE_CLIENTES.ESTADO, NOTAS_FISCAIS.TIPO_VENDA, TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,'YYYY-MM') AS MES_ANO, 
COUNT(NOTAS_FISCAIS.NUMERO) AS NUMERO_VENDAS  FROM NOTAS_FISCAIS
INNER JOIN TABELA_DE_CLIENTES ON NOTAS_FISCAIS.CPF = TABELA_DE_CLIENTES.CPF
GROUP BY TABELA_DE_CLIENTES.ESTADO, NOTAS_FISCAIS.TIPO_VENDA, TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,'YYYY-MM')
ORDER BY TABELA_DE_CLIENTES.ESTADO, NOTAS_FISCAIS.TIPO_VENDA, TO_CHAR(NOTAS_FISCAIS.DATA_VENDA,'YYYY-MM');





